/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.config;

import java.text.ParseException;
import javax.swing.JFormattedTextField;

final class UnitFormatter
extends JFormattedTextField.AbstractFormatter {
    private final String units;

    UnitFormatter(String units) {
        this.units = units;
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        String trimmedText = text.endsWith(this.units) ? text.substring(0, text.length() - this.units.length()) : text;
        try {
            return Integer.valueOf(trimmedText);
        }
        catch (NumberFormatException e) {
            throw new ParseException(trimmedText + " is not an integer.", 0);
        }
    }

    @Override
    public String valueToString(Object value) {
        return String.valueOf(value) + this.units;
    }
}

