/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.worldhopper;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Set;
import net.runelite.http.api.worlds.WorldType;

enum WorldTypeFilter {
    NORMAL{

        @Override
        boolean matches(Set<WorldType> types) {
            EnumSet<WorldType> normal = EnumSet.of(WorldType.MEMBERS, WorldType.BOUNTY, WorldType.SKILL_TOTAL, WorldType.LAST_MAN_STANDING);
            EnumSet<WorldType> inverse = EnumSet.complementOf(normal);
            return Sets.intersection(types, inverse).isEmpty();
        }
    }
    ,
    DEADMAN{

        @Override
        boolean matches(Set<WorldType> types) {
            return types.contains((Object)WorldType.DEADMAN);
        }
    }
    ,
    SEASONAL{

        @Override
        boolean matches(Set<WorldType> types) {
            return types.contains((Object)WorldType.SEASONAL);
        }
    }
    ,
    QUEST_SPEEDRUNNING{

        @Override
        boolean matches(Set<WorldType> types) {
            return types.contains((Object)WorldType.QUEST_SPEEDRUNNING);
        }
    }
    ,
    FRESH_START_WORLD{

        @Override
        boolean matches(Set<WorldType> types) {
            return types.contains((Object)WorldType.FRESH_START_WORLD);
        }
    }
    ,
    PVP{

        @Override
        boolean matches(Set<WorldType> types) {
            return types.contains((Object)WorldType.PVP);
        }
    }
    ,
    SKILL_TOTAL{

        @Override
        boolean matches(Set<WorldType> types) {
            return types.contains((Object)WorldType.SKILL_TOTAL);
        }
    }
    ,
    HIGH_RISK{

        @Override
        boolean matches(Set<WorldType> types) {
            return types.contains((Object)WorldType.HIGH_RISK);
        }
    };


    abstract boolean matches(Set<WorldType> var1);
}

