/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.rs;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import net.runelite.mapping.ObfuscatedGetter;
import net.runelite.mapping.ObfuscatedName;
import net.runelite.mapping.ObfuscatedSignature;

public class Reflection {
    private static final boolean PRINT_DEBUG_MESSAGES = false;
    private static Map<String, Class<?>> classes = new HashMap();

    public static Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = classes.get(name);
        if (clazz != null) {
            return clazz;
        }
        return Class.forName(name);
    }

    public static Field findField(Class<?> clazz, String name) throws NoSuchFieldException {
        for (Field f : clazz.getDeclaredFields()) {
            ObfuscatedName annotation = f.getAnnotation(ObfuscatedName.class);
            if (annotation == null || !annotation.value().equals(name)) continue;
            return f;
        }
        return clazz.getDeclaredField(name);
    }

    public static String getMethodName(Method method) {
        ObfuscatedName annotation = method.getAnnotation(ObfuscatedName.class);
        if (annotation != null) {
            return annotation.value();
        }
        return method.getName();
    }

    public static Class<?>[] getParameterTypes(Method method) {
        Class<Number> last;
        ObfuscatedSignature sig = method.getAnnotation(ObfuscatedSignature.class);
        Class<?>[] types = method.getParameterTypes();
        if (sig == null) {
            return types;
        }
        String s = sig.signature();
        int i = s.lastIndexOf(41);
        char c = s.charAt(i - 1);
        switch (c) {
            case 'B': {
                last = Byte.TYPE;
                break;
            }
            case 'I': {
                last = Integer.TYPE;
                break;
            }
            case 'S': {
                last = Short.TYPE;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        types = Arrays.copyOf(types, types.length + 1);
        types[types.length - 1] = last;
        return types;
    }

    public static int getInt(Field field, Object obj) throws IllegalArgumentException, IllegalAccessException {
        int i;
        boolean unset = false;
        if ((field.getModifiers() & 2) == 0) {
            field.setAccessible(true);
            unset = true;
        }
        try {
            i = field.getInt(obj);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (unset) {
                field.setAccessible(false);
            }
        }
        ObfuscatedGetter og = field.getAnnotation(ObfuscatedGetter.class);
        if (og != null) {
            int getter = og.intValue();
            int setter = Reflection.modInverse(getter);
            i *= setter;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInt(Field field, Object obj, int value) throws IllegalArgumentException, IllegalAccessException {
        ObfuscatedGetter og = field.getAnnotation(ObfuscatedGetter.class);
        if (og != null) {
            int getter = og.intValue();
            value *= getter;
        }
        boolean unset = false;
        if ((field.getModifiers() & 2) == 0) {
            field.setAccessible(true);
            unset = true;
        }
        try {
            field.setInt(obj, value);
        }
        finally {
            if (unset) {
                field.setAccessible(false);
            }
        }
    }

    public static BigInteger modInverse(BigInteger val, int bits) {
        BigInteger shift = BigInteger.ONE.shiftLeft(bits);
        return val.modInverse(shift);
    }

    public static int modInverse(int val) {
        return Reflection.modInverse(BigInteger.valueOf(val), 32).intValue();
    }

    public static Object invoke(Method method, Object object, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return method.invoke(object, args);
    }

    static {
        try {
            Enumeration<URL> systemResources = ClassLoader.getSystemResources("");
            while (systemResources.hasMoreElements()) {
                Path path;
                URL url = systemResources.nextElement();
                if (url.toString().startsWith("jar:")) continue;
                try {
                    path = new File(url.toURI()).toPath();
                }
                catch (URISyntaxException e) {
                    path = new File(url.getPath()).toPath();
                }
                Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(f -> {
                    String className = f.getName(f.getNameCount() - 1).toString().replace(".class", "");
                    try {
                        Class<?> clazz = Class.forName(className);
                        ObfuscatedName obfuscatedName = clazz.getAnnotation(ObfuscatedName.class);
                        if (obfuscatedName != null) {
                            classes.put(obfuscatedName.value(), clazz);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                });
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

